package io.burkard.cdk.services.appsync.cfnDataSource

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RdsHttpEndpointConfigProperty {

  def apply(
    dbClusterIdentifier: String,
    awsRegion: String,
    awsSecretStoreArn: String,
    schema: Option[String] = None,
    databaseName: Option[String] = None
  ): software.amazon.awscdk.services.appsync.CfnDataSource.RdsHttpEndpointConfigProperty =
    (new software.amazon.awscdk.services.appsync.CfnDataSource.RdsHttpEndpointConfigProperty.Builder)
      .dbClusterIdentifier(dbClusterIdentifier)
      .awsRegion(awsRegion)
      .awsSecretStoreArn(awsSecretStoreArn)
      .schema(schema.orNull)
      .databaseName(databaseName.orNull)
      .build()
}
