package io.burkard.cdk.services.appflow.cfnConnectorProfile

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RedshiftConnectorProfilePropertiesProperty {

  def apply(
    databaseUrl: String,
    bucketName: String,
    roleArn: String,
    bucketPrefix: Option[String] = None
  ): software.amazon.awscdk.services.appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty =
    (new software.amazon.awscdk.services.appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty.Builder)
      .databaseUrl(databaseUrl)
      .bucketName(bucketName)
      .roleArn(roleArn)
      .bucketPrefix(bucketPrefix.orNull)
      .build()
}
