package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Stage {

  def apply(
    internalResourceId: String,
    env: Option[software.amazon.awscdk.Environment] = None,
    outdir: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.Stage =
    software.amazon.awscdk.Stage.Builder
      .create(stackCtx, internalResourceId)
      .env(env.orNull)
      .outdir(outdir.orNull)
      .build()
}
