package io.burkard.cdk.services.sagemaker.cfnEndpointConfig

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DataCaptureConfigProperty {

  def apply(
    initialSamplingPercentage: Number,
    captureOptions: List[_],
    destinationS3Uri: String,
    enableCapture: Option[Boolean] = None,
    captureContentTypeHeader: Option[software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty] = None,
    kmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty.Builder)
      .initialSamplingPercentage(initialSamplingPercentage)
      .captureOptions(captureOptions.asJava)
      .destinationS3Uri(destinationS3Uri)
      .enableCapture(enableCapture.map(Boolean.box).orNull)
      .captureContentTypeHeader(captureContentTypeHeader.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
