package io.burkard.cdk.services.rum

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAppMonitor {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    domain: Option[String] = None,
    cwLogEnabled: Option[Boolean] = None,
    appMonitorConfiguration: Option[software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.rum.CfnAppMonitor =
    software.amazon.awscdk.services.rum.CfnAppMonitor.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .domain(domain.orNull)
      .cwLogEnabled(cwLogEnabled.map(Boolean.box).orNull)
      .appMonitorConfiguration(appMonitorConfiguration.orNull)
      .build()
}
