package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTrackerProps {

  def apply(
    trackerName: String,
    pricingPlan: String,
    description: Option[String] = None,
    positionFiltering: Option[String] = None,
    pricingPlanDataSource: Option[String] = None,
    kmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnTrackerProps =
    (new software.amazon.awscdk.services.location.CfnTrackerProps.Builder)
      .trackerName(trackerName)
      .pricingPlan(pricingPlan)
      .description(description.orNull)
      .positionFiltering(positionFiltering.orNull)
      .pricingPlanDataSource(pricingPlanDataSource.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
