package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EksOptimizedImageProps {

  def apply(
    nodeType: Option[software.amazon.awscdk.services.eks.NodeType] = None,
    kubernetesVersion: Option[String] = None,
    cpuArch: Option[software.amazon.awscdk.services.eks.CpuArch] = None
  ): software.amazon.awscdk.services.eks.EksOptimizedImageProps =
    (new software.amazon.awscdk.services.eks.EksOptimizedImageProps.Builder)
      .nodeType(nodeType.orNull)
      .kubernetesVersion(kubernetesVersion.orNull)
      .cpuArch(cpuArch.orNull)
      .build()
}
