package io.burkard.cdk.services.ecs.cfnTaskDefinition

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogConfigurationProperty {

  def apply(
    logDriver: String,
    options: Option[Map[String, String]] = None,
    secretOptions: Option[List[_]] = None
  ): software.amazon.awscdk.services.ecs.CfnTaskDefinition.LogConfigurationProperty =
    (new software.amazon.awscdk.services.ecs.CfnTaskDefinition.LogConfigurationProperty.Builder)
      .logDriver(logDriver)
      .options(options.map(_.asJava).orNull)
      .secretOptions(secretOptions.map(_.asJava).orNull)
      .build()
}
