package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BottleRocketImageProps {

  def apply(
    variant: Option[software.amazon.awscdk.services.ecs.BottlerocketEcsVariant] = None,
    cachedInContext: Option[Boolean] = None,
    architecture: Option[software.amazon.awscdk.services.ec2.InstanceArchitecture] = None
  ): software.amazon.awscdk.services.ecs.BottleRocketImageProps =
    (new software.amazon.awscdk.services.ecs.BottleRocketImageProps.Builder)
      .variant(variant.orNull)
      .cachedInContext(cachedInContext.map(Boolean.box).orNull)
      .architecture(architecture.orNull)
      .build()
}
