package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptions {

  def apply(
    encrypted: Option[Boolean] = None,
    iops: Option[Number] = None,
    deleteOnTermination: Option[Boolean] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceOptions =
    (new software.amazon.awscdk.services.ec2.EbsDeviceOptions.Builder)
      .encrypted(encrypted.map(Boolean.box).orNull)
      .iops(iops.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .volumeType(volumeType.orNull)
      .build()
}
