package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHostProps {

  def apply(
    instanceType: String,
    availabilityZone: String,
    hostRecovery: Option[String] = None,
    autoPlacement: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnHostProps =
    (new software.amazon.awscdk.services.ec2.CfnHostProps.Builder)
      .instanceType(instanceType)
      .availabilityZone(availabilityZone)
      .hostRecovery(hostRecovery.orNull)
      .autoPlacement(autoPlacement.orNull)
      .build()
}
