package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCapacityReservation {

  def apply(
    internalResourceId: String,
    availabilityZone: String,
    instanceType: String,
    instanceCount: Number,
    instancePlatform: String,
    ebsOptimized: Option[Boolean] = None,
    tagSpecifications: Option[List[_]] = None,
    endDate: Option[String] = None,
    instanceMatchCriteria: Option[String] = None,
    outPostArn: Option[String] = None,
    ephemeralStorage: Option[Boolean] = None,
    tenancy: Option[String] = None,
    placementGroupArn: Option[String] = None,
    endDateType: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnCapacityReservation =
    software.amazon.awscdk.services.ec2.CfnCapacityReservation.Builder
      .create(stackCtx, internalResourceId)
      .availabilityZone(availabilityZone)
      .instanceType(instanceType)
      .instanceCount(instanceCount)
      .instancePlatform(instancePlatform)
      .ebsOptimized(ebsOptimized.map(Boolean.box).orNull)
      .tagSpecifications(tagSpecifications.map(_.asJava).orNull)
      .endDate(endDate.orNull)
      .instanceMatchCriteria(instanceMatchCriteria.orNull)
      .outPostArn(outPostArn.orNull)
      .ephemeralStorage(ephemeralStorage.map(Boolean.box).orNull)
      .tenancy(tenancy.orNull)
      .placementGroupArn(placementGroupArn.orNull)
      .endDateType(endDateType.orNull)
      .build()
}
