package io.burkard.cdk.services.connect

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnContactFlowModuleProps {

  def apply(
    name: String,
    content: String,
    instanceArn: String,
    state: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.connect.CfnContactFlowModuleProps =
    (new software.amazon.awscdk.services.connect.CfnContactFlowModuleProps.Builder)
      .name(name)
      .content(content)
      .instanceArn(instanceArn)
      .state(state.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
