package io.burkard.cdk.services.config

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnOrganizationConfigRule {

  def apply(
    internalResourceId: String,
    organizationConfigRuleName: String,
    excludedAccounts: Option[List[String]] = None,
    organizationCustomRuleMetadata: Option[software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty] = None,
    organizationManagedRuleMetadata: Option[software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.config.CfnOrganizationConfigRule =
    software.amazon.awscdk.services.config.CfnOrganizationConfigRule.Builder
      .create(stackCtx, internalResourceId)
      .organizationConfigRuleName(organizationConfigRuleName)
      .excludedAccounts(excludedAccounts.map(_.asJava).orNull)
      .organizationCustomRuleMetadata(organizationCustomRuleMetadata.orNull)
      .organizationManagedRuleMetadata(organizationManagedRuleMetadata.orNull)
      .build()
}
