package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StringAttribute {

  def apply(
    minLen: Option[Number] = None,
    mutable: Option[Boolean] = None,
    maxLen: Option[Number] = None
  ): software.amazon.awscdk.services.cognito.StringAttribute =
    software.amazon.awscdk.services.cognito.StringAttribute.Builder
      .create()
      .minLen(minLen.orNull)
      .mutable(mutable.map(Boolean.box).orNull)
      .maxLen(maxLen.orNull)
      .build()
}
