package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PasswordPolicy {

  def apply(
    requireLowercase: Option[Boolean] = None,
    requireDigits: Option[Boolean] = None,
    requireSymbols: Option[Boolean] = None,
    tempPasswordValidity: Option[software.amazon.awscdk.Duration] = None,
    requireUppercase: Option[Boolean] = None,
    minLength: Option[Number] = None
  ): software.amazon.awscdk.services.cognito.PasswordPolicy =
    (new software.amazon.awscdk.services.cognito.PasswordPolicy.Builder)
      .requireLowercase(requireLowercase.map(Boolean.box).orNull)
      .requireDigits(requireDigits.map(Boolean.box).orNull)
      .requireSymbols(requireSymbols.map(Boolean.box).orNull)
      .tempPasswordValidity(tempPasswordValidity.orNull)
      .requireUppercase(requireUppercase.map(Boolean.box).orNull)
      .minLength(minLength.orNull)
      .build()
}
