package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricConfig {

  def apply(
    metricStat: Option[software.amazon.awscdk.services.cloudwatch.MetricStatConfig] = None,
    renderingProperties: Option[Map[String, _]] = None,
    mathExpression: Option[software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig] = None
  ): software.amazon.awscdk.services.cloudwatch.MetricConfig =
    (new software.amazon.awscdk.services.cloudwatch.MetricConfig.Builder)
      .metricStat(metricStat.orNull)
      .renderingProperties(renderingProperties.map(_.asJava).orNull)
      .mathExpression(mathExpression.orNull)
      .build()
}
