package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFunctionProps {

  def apply(
    name: String,
    autoPublish: Option[Boolean] = None,
    functionCode: Option[String] = None,
    functionConfig: Option[software.amazon.awscdk.services.cloudfront.CfnFunction.FunctionConfigProperty] = None
  ): software.amazon.awscdk.services.cloudfront.CfnFunctionProps =
    (new software.amazon.awscdk.services.cloudfront.CfnFunctionProps.Builder)
      .name(name)
      .autoPublish(autoPublish.map(Boolean.box).orNull)
      .functionCode(functionCode.orNull)
      .functionConfig(functionConfig.orNull)
      .build()
}
