package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GatewayRoute {

  def apply(
    internalResourceId: String,
    virtualGateway: software.amazon.awscdk.services.appmesh.IVirtualGateway,
    routeSpec: Option[software.amazon.awscdk.services.appmesh.GatewayRouteSpec] = None,
    gatewayRouteName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appmesh.GatewayRoute =
    software.amazon.awscdk.services.appmesh.GatewayRoute.Builder
      .create(stackCtx, internalResourceId)
      .virtualGateway(virtualGateway)
      .routeSpec(routeSpec.orNull)
      .gatewayRouteName(gatewayRouteName.orNull)
      .build()
}
