package io.burkard.cdk.services.transfer

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkflow {

  def apply(
    internalResourceId: String,
    steps: List[_],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    onExceptionSteps: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.transfer.CfnWorkflow =
    software.amazon.awscdk.services.transfer.CfnWorkflow.Builder
      .create(stackCtx, internalResourceId)
      .steps(steps.asJava)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .onExceptionSteps(onExceptionSteps.map(_.asJava).orNull)
      .build()
}
