package io.burkard.cdk.services.timestream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3ConfigurationProperty {

  def apply(
    bucketName: String,
    objectKeyPrefix: Option[String] = None,
    encryptionOption: Option[String] = None
  ): software.amazon.awscdk.services.timestream.CfnScheduledQuery.S3ConfigurationProperty =
    (new software.amazon.awscdk.services.timestream.CfnScheduledQuery.S3ConfigurationProperty.Builder)
      .bucketName(bucketName)
      .objectKeyPrefix(objectKeyPrefix.orNull)
      .encryptionOption(encryptionOption.orNull)
      .build()
}
