package io.burkard.cdk.services.timestream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3ConfigurationProperty {

  def apply(
    bucketName: String,
    encryptionOption: Option[String] = None,
    objectKeyPrefix: Option[String] = None
  ): software.amazon.awscdk.services.timestream.CfnScheduledQuery.S3ConfigurationProperty =
    (new software.amazon.awscdk.services.timestream.CfnScheduledQuery.S3ConfigurationProperty.Builder)
      .bucketName(bucketName)
      .encryptionOption(encryptionOption.orNull)
      .objectKeyPrefix(objectKeyPrefix.orNull)
      .build()
}
