package io.burkard.cdk.services.synthetics

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3EncryptionProperty {

  def apply(
    encryptionMode: Option[String] = None,
    kmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.synthetics.CfnCanary.S3EncryptionProperty =
    (new software.amazon.awscdk.services.synthetics.CfnCanary.S3EncryptionProperty.Builder)
      .encryptionMode(encryptionMode.orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
