package io.burkard.cdk.services.stepfunctions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InstanceResizePolicyProperty {

  def apply(
    instancesToProtect: Option[List[String]] = None,
    instancesToTerminate: Option[List[String]] = None,
    instanceTerminationTimeout: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty =
    (new software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty.Builder)
      .instancesToProtect(instancesToProtect.map(_.asJava).orNull)
      .instancesToTerminate(instancesToTerminate.map(_.asJava).orNull)
      .instanceTerminationTimeout(instanceTerminationTimeout.orNull)
      .build()
}
