package io.burkard.cdk.services.stepfunctions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResourceConfig {

  def apply(
    instanceCount: Number,
    volumeSize: software.amazon.awscdk.Size,
    instanceType: software.amazon.awscdk.services.ec2.InstanceType,
    volumeEncryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig =
    (new software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig.Builder)
      .instanceCount(instanceCount)
      .volumeSize(volumeSize)
      .instanceType(instanceType)
      .volumeEncryptionKey(volumeEncryptionKey.orNull)
      .build()
}
