package io.burkard.cdk.services.ssm

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3OutputLocationProperty {

  def apply(
    outputS3BucketName: Option[String] = None,
    outputS3KeyPrefix: Option[String] = None,
    outputS3Region: Option[String] = None
  ): software.amazon.awscdk.services.ssm.CfnAssociation.S3OutputLocationProperty =
    (new software.amazon.awscdk.services.ssm.CfnAssociation.S3OutputLocationProperty.Builder)
      .outputS3BucketName(outputS3BucketName.orNull)
      .outputS3KeyPrefix(outputS3KeyPrefix.orNull)
      .outputS3Region(outputS3Region.orNull)
      .build()
}
