package io.burkard.cdk.services.sns

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EmailSubscription {

  def apply(
    emailAddress: String,
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    json: Option[Boolean] = None
  ): software.amazon.awscdk.services.sns.subscriptions.EmailSubscription =
    software.amazon.awscdk.services.sns.subscriptions.EmailSubscription.Builder
      .create(emailAddress)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .json(json.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
