package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BounceTemplateProps {

  def apply(
    message: String,
    smtpReplyCode: String,
    statusCode: Option[String] = None
  ): software.amazon.awscdk.services.ses.actions.BounceTemplateProps =
    (new software.amazon.awscdk.services.ses.actions.BounceTemplateProps.Builder)
      .message(message)
      .smtpReplyCode(smtpReplyCode)
      .statusCode(statusCode.orNull)
      .build()
}
