package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3ActionProperty {

  def apply(
    bucketName: String,
    topicArn: Option[String] = None,
    objectKeyPrefix: Option[String] = None,
    kmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.ses.CfnReceiptRule.S3ActionProperty =
    (new software.amazon.awscdk.services.ses.CfnReceiptRule.S3ActionProperty.Builder)
      .bucketName(bucketName)
      .topicArn(topicArn.orNull)
      .objectKeyPrefix(objectKeyPrefix.orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
