package io.burkard.cdk.services.servicediscovery

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BaseServiceProps {

  def apply(
    name: Option[String] = None,
    description: Option[String] = None,
    healthCheck: Option[software.amazon.awscdk.services.servicediscovery.HealthCheckConfig] = None,
    customHealthCheck: Option[software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig] = None
  ): software.amazon.awscdk.services.servicediscovery.BaseServiceProps =
    (new software.amazon.awscdk.services.servicediscovery.BaseServiceProps.Builder)
      .name(name.orNull)
      .description(description.orNull)
      .healthCheck(healthCheck.orNull)
      .customHealthCheck(customHealthCheck.orNull)
      .build()
}
