package io.burkard.cdk.services.secretsmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRotationScheduleProps {

  def apply(
    secretId: String,
    hostedRotationLambda: Option[software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty] = None,
    rotationLambdaArn: Option[String] = None,
    rotationRules: Option[software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty] = None
  ): software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps =
    (new software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder)
      .secretId(secretId)
      .hostedRotationLambda(hostedRotationLambda.orNull)
      .rotationLambdaArn(rotationLambdaArn.orNull)
      .rotationRules(rotationRules.orNull)
      .build()
}
