package io.burkard.cdk.services.sam

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SQSEventProperty {

  def apply(
    queue: String,
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None
  ): software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty =
    (new software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty.Builder)
      .queue(queue)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .batchSize(batchSize.orNull)
      .build()
}
