package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnModelBiasJobDefinition {

  def apply(
    internalResourceId: String,
    modelBiasJobOutputConfig: software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty,
    jobResources: software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty,
    modelBiasAppSpecification: software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty,
    roleArn: String,
    modelBiasJobInput: software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty,
    networkConfig: Option[software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty] = None,
    modelBiasBaselineConfig: Option[software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    stoppingCondition: Option[software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty] = None,
    jobDefinitionName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition =
    software.amazon.awscdk.services.sagemaker.CfnModelBiasJobDefinition.Builder
      .create(stackCtx, internalResourceId)
      .modelBiasJobOutputConfig(modelBiasJobOutputConfig)
      .jobResources(jobResources)
      .modelBiasAppSpecification(modelBiasAppSpecification)
      .roleArn(roleArn)
      .modelBiasJobInput(modelBiasJobInput)
      .networkConfig(networkConfig.orNull)
      .modelBiasBaselineConfig(modelBiasBaselineConfig.orNull)
      .tags(tags.map(_.asJava).orNull)
      .stoppingCondition(stoppingCondition.orNull)
      .jobDefinitionName(jobDefinitionName.orNull)
      .build()
}
