package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NoncurrentVersionTransitionProperty {

  def apply(
    storageClass: String,
    transitionInDays: Number,
    newerNoncurrentVersions: Option[Number] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty.Builder)
      .storageClass(storageClass)
      .transitionInDays(transitionInDays)
      .newerNoncurrentVersions(newerNoncurrentVersions.orNull)
      .build()
}
