package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NoncurrentVersionExpirationProperty {

  def apply(
    noncurrentDays: Number,
    newerNoncurrentVersions: Option[Number] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionExpirationProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionExpirationProperty.Builder)
      .noncurrentDays(noncurrentDays)
      .newerNoncurrentVersions(newerNoncurrentVersions.orNull)
      .build()
}
