package io.burkard.cdk.services.s3

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AnalyticsConfigurationProperty {

  def apply(
    id: String,
    storageClassAnalysis: software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty,
    prefix: Option[String] = None,
    tagFilters: Option[List[_]] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty.Builder)
      .id(id)
      .storageClassAnalysis(storageClassAnalysis)
      .prefix(prefix.orNull)
      .tagFilters(tagFilters.map(_.asJava).orNull)
      .build()
}
