package io.burkard.cdk.services.rum

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAppMonitorProps {

  def apply(
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    domain: Option[String] = None,
    cwLogEnabled: Option[Boolean] = None,
    appMonitorConfiguration: Option[software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty] = None
  ): software.amazon.awscdk.services.rum.CfnAppMonitorProps =
    (new software.amazon.awscdk.services.rum.CfnAppMonitorProps.Builder)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .domain(domain.orNull)
      .cwLogEnabled(cwLogEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .appMonitorConfiguration(appMonitorConfiguration.orNull)
      .build()
}
