package io.burkard.cdk.services.route53resolver

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FirewallRuleProperty {

  def apply(
    priority: Number,
    firewallDomainListId: String,
    action: String,
    blockOverrideTtl: Option[Number] = None,
    blockOverrideDnsType: Option[String] = None,
    blockOverrideDomain: Option[String] = None,
    blockResponse: Option[String] = None
  ): software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup.FirewallRuleProperty =
    (new software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroup.FirewallRuleProperty.Builder)
      .priority(priority)
      .firewallDomainListId(firewallDomainListId)
      .action(action)
      .blockOverrideTtl(blockOverrideTtl.orNull)
      .blockOverrideDnsType(blockOverrideDnsType.orNull)
      .blockOverrideDomain(blockOverrideDomain.orNull)
      .blockResponse(blockResponse.orNull)
      .build()
}
