package io.burkard.cdk.services.route53recoveryreadiness

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourceSetProps {

  def apply(
    resources: List[_],
    resourceSetName: String,
    resourceSetType: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSetProps =
    (new software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSetProps.Builder)
      .resources(resources.asJava)
      .resourceSetName(resourceSetName)
      .resourceSetType(resourceSetType)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
