package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HostedZoneProps {

  def apply(
    comment: Option[String] = None,
    zoneName: Option[String] = None,
    vpcs: Option[List[_ <: software.amazon.awscdk.services.ec2.IVpc]] = None,
    queryLogsLogGroupArn: Option[String] = None
  ): software.amazon.awscdk.services.route53.HostedZoneProps =
    (new software.amazon.awscdk.services.route53.HostedZoneProps.Builder)
      .comment(comment.orNull)
      .zoneName(zoneName.orNull)
      .vpcs(vpcs.map(_.asJava).orNull)
      .queryLogsLogGroupArn(queryLogsLogGroupArn.orNull)
      .build()
}
