package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRecordSetGroupProps {

  def apply(
    comment: Option[String] = None,
    recordSets: Option[List[_]] = None,
    hostedZoneId: Option[String] = None,
    hostedZoneName: Option[String] = None
  ): software.amazon.awscdk.services.route53.CfnRecordSetGroupProps =
    (new software.amazon.awscdk.services.route53.CfnRecordSetGroupProps.Builder)
      .comment(comment.orNull)
      .recordSets(recordSets.map(_.asJava).orNull)
      .hostedZoneId(hostedZoneId.orNull)
      .hostedZoneName(hostedZoneName.orNull)
      .build()
}
