package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CaaAmazonRecord {

  def apply(
    internalResourceId: String,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    comment: Option[String] = None,
    zone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None,
    recordName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.CaaAmazonRecord =
    software.amazon.awscdk.services.route53.CaaAmazonRecord.Builder
      .create(stackCtx, internalResourceId)
      .ttl(ttl.orNull)
      .comment(comment.orNull)
      .zone(zone.orNull)
      .recordName(recordName.orNull)
      .build()
}
