package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcEndpointServiceDomainName {

  def apply(
    internalResourceId: String,
    domainName: String,
    endpointService: software.amazon.awscdk.services.ec2.IVpcEndpointService,
    publicHostedZone: software.amazon.awscdk.services.route53.IPublicHostedZone
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName =
    software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName.Builder
      .create(stackCtx, internalResourceId)
      .domainName(domainName)
      .endpointService(endpointService)
      .publicHostedZone(publicHostedZone)
      .build()
}
