package io.burkard.cdk.services.resiliencehub

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResourceMappingProperty {

  def apply(
    mappingType: String,
    physicalResourceId: software.amazon.awscdk.services.resiliencehub.CfnApp.PhysicalResourceIdProperty,
    resourceName: Option[String] = None,
    logicalStackName: Option[String] = None
  ): software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty =
    (new software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty.Builder)
      .mappingType(mappingType)
      .physicalResourceId(physicalResourceId)
      .resourceName(resourceName.orNull)
      .logicalStackName(logicalStackName.orNull)
      .build()
}
