package io.burkard.cdk.services.quicksight

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTemplate {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    awsAccountId: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    permissions: Option[List[_]] = None,
    templateId: Option[String] = None,
    versionDescription: Option[String] = None,
    sourceEntity: Option[software.amazon.awscdk.services.quicksight.CfnTemplate.TemplateSourceEntityProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.quicksight.CfnTemplate =
    software.amazon.awscdk.services.quicksight.CfnTemplate.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .awsAccountId(awsAccountId.orNull)
      .tags(tags.map(_.asJava).orNull)
      .permissions(permissions.map(_.asJava).orNull)
      .templateId(templateId.orNull)
      .versionDescription(versionDescription.orNull)
      .sourceEntity(sourceEntity.orNull)
      .build()
}
