package io.burkard.cdk.pipelines

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodeCommitSourceOptions {

  def apply(
    trigger: Option[software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger] = None,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    codeBuildCloneOutput: Option[Boolean] = None
  ): software.amazon.awscdk.pipelines.CodeCommitSourceOptions =
    (new software.amazon.awscdk.pipelines.CodeCommitSourceOptions.Builder)
      .trigger(trigger.orNull)
      .eventRole(eventRole.orNull)
      .codeBuildCloneOutput(codeBuildCloneOutput.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
