package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBaiduChannel {

  def apply(
    internalResourceId: String,
    apiKey: String,
    applicationId: String,
    secretKey: String,
    enabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnBaiduChannel =
    software.amazon.awscdk.services.pinpoint.CfnBaiduChannel.Builder
      .create(stackCtx, internalResourceId)
      .apiKey(apiKey)
      .applicationId(applicationId)
      .secretKey(secretKey)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
