package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnADMChannelProps {

  def apply(
    applicationId: String,
    clientId: String,
    clientSecret: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnADMChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnADMChannelProps.Builder)
      .applicationId(applicationId)
      .clientId(clientId)
      .clientSecret(clientSecret)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
