package io.burkard.cdk.services.opsworks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ChefConfigurationProperty {

  def apply(
    berkshelfVersion: Option[String] = None,
    manageBerkshelf: Option[Boolean] = None
  ): software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty =
    (new software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty.Builder)
      .berkshelfVersion(berkshelfVersion.orNull)
      .manageBerkshelf(manageBerkshelf.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
