package io.burkard.cdk.services.opensearchservice

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ZoneAwarenessConfig {

  def apply(
    enabled: Option[Boolean] = None,
    availabilityZoneCount: Option[Number] = None
  ): software.amazon.awscdk.services.opensearchservice.ZoneAwarenessConfig =
    (new software.amazon.awscdk.services.opensearchservice.ZoneAwarenessConfig.Builder)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .availabilityZoneCount(availabilityZoneCount.orNull)
      .build()
}
